<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('leave_balances', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained()->onDelete('cascade');
            $table->foreignId('employee_id')->constrained()->onDelete('cascade');
            $table->foreignId('leave_type_id')->constrained()->onDelete('cascade');
            $table->integer('year');
            $table->decimal('total_days', 8, 2)->comment('إجمالي أيام الإجازة المستحقة');
            $table->decimal('used_days', 8, 2)->default(0)->comment('أيام الإجازة المستخدمة');
            $table->decimal('pending_days', 8, 2)->default(0)->comment('أيام الإجازة المعلقة (قيد الموافقة)');
            $table->decimal('remaining_days', 8, 2)->comment('أيام الإجازة المتبقية');
            $table->decimal('carried_over_days', 8, 2)->default(0)->comment('أيام الإجازة المرحلة من السنة السابقة');
            $table->text('notes')->nullable();
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->timestamps();

            $table->unique(['employee_id', 'leave_type_id', 'year']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('leave_balances');
    }
};
