<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('tax_brackets', function (Blueprint $table) {
            // إضافة حقل الاسم
            if (!Schema::hasColumn('tax_brackets', 'name')) {
                $table->string('name')->after('company_id');
            }

            // تغيير اسم حقل نسبة الضريبة
            if (Schema::hasColumn('tax_brackets', 'tax_percentage') && !Schema::hasColumn('tax_brackets', 'tax_rate')) {
                $table->renameColumn('tax_percentage', 'tax_rate');
            }

            // حذف حقل المبلغ الثابت
            if (Schema::hasColumn('tax_brackets', 'fixed_amount')) {
                $table->dropColumn('fixed_amount');
            }

            // حذف حقول تاريخ السريان وتاريخ الانتهاء
            if (Schema::hasColumn('tax_brackets', 'effective_date')) {
                $table->dropColumn('effective_date');
            }

            if (Schema::hasColumn('tax_brackets', 'expiry_date')) {
                $table->dropColumn('expiry_date');
            }

            // إضافة حقل الحالة
            if (!Schema::hasColumn('tax_brackets', 'is_active')) {
                $table->boolean('is_active')->default(true)->after('tax_rate');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('tax_brackets', function (Blueprint $table) {
            // إعادة الحقول إلى حالتها السابقة
            if (Schema::hasColumn('tax_brackets', 'name')) {
                $table->dropColumn('name');
            }

            if (Schema::hasColumn('tax_brackets', 'tax_rate') && !Schema::hasColumn('tax_brackets', 'tax_percentage')) {
                $table->renameColumn('tax_rate', 'tax_percentage');
            }

            if (!Schema::hasColumn('tax_brackets', 'fixed_amount')) {
                $table->decimal('fixed_amount', 10, 2)->default(0);
            }

            if (!Schema::hasColumn('tax_brackets', 'effective_date')) {
                $table->date('effective_date')->nullable();
            }

            if (!Schema::hasColumn('tax_brackets', 'expiry_date')) {
                $table->date('expiry_date')->nullable();
            }

            if (Schema::hasColumn('tax_brackets', 'is_active')) {
                $table->dropColumn('is_active');
            }
        });
    }
};
