<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('salary_policies', function (Blueprint $table) {
            // إضافة حقل الاسم إذا لم يكن موجودًا
            if (!Schema::hasColumn('salary_policies', 'name')) {
                $table->string('name')->after('company_id');
            }

            // تعديل حقول معدلات العمل الإضافي
            if (Schema::hasColumn('salary_policies', 'overtime_rate_weekday')) {
                $table->dropColumn('overtime_rate_weekday');
            }
            if (Schema::hasColumn('salary_policies', 'overtime_rate_weekend')) {
                $table->dropColumn('overtime_rate_weekend');
            }
            if (Schema::hasColumn('salary_policies', 'overtime_rate_holiday')) {
                $table->dropColumn('overtime_rate_holiday');
            }

            // إضافة حقل معدل العمل الإضافي الموحد
            if (!Schema::hasColumn('salary_policies', 'overtime_rate')) {
                $table->decimal('overtime_rate', 5, 2)->default(1.5)->after('social_insurance_company_percentage');
            }

            // تعديل حقل نسبة التأمينات الاجتماعية
            if (
                Schema::hasColumn('salary_policies', 'social_insurance_employee_percentage') &&
                Schema::hasColumn('salary_policies', 'social_insurance_company_percentage')
            ) {
                $table->dropColumn('social_insurance_employee_percentage');
                $table->dropColumn('social_insurance_company_percentage');
                $table->decimal('social_insurance_percentage', 5, 2)->default(0)->after('tax_calculation_method');
            }

            // إضافة حقل طريقة خصم الغياب
            if (!Schema::hasColumn('salary_policies', 'absence_deduction_method')) {
                $table->enum('absence_deduction_method', ['daily', 'hourly'])->default('daily')->after('absence_deduction_rate');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('salary_policies', function (Blueprint $table) {
            // إعادة الحقول إلى حالتها السابقة
            if (Schema::hasColumn('salary_policies', 'name')) {
                $table->dropColumn('name');
            }

            if (Schema::hasColumn('salary_policies', 'overtime_rate')) {
                $table->dropColumn('overtime_rate');
                $table->decimal('overtime_rate_weekday', 5, 2)->default(1.5);
                $table->decimal('overtime_rate_weekend', 5, 2)->default(2.0);
                $table->decimal('overtime_rate_holiday', 5, 2)->default(2.5);
            }

            if (Schema::hasColumn('salary_policies', 'social_insurance_percentage')) {
                $table->dropColumn('social_insurance_percentage');
                $table->decimal('social_insurance_employee_percentage', 5, 2)->default(0);
                $table->decimal('social_insurance_company_percentage', 5, 2)->default(0);
            }

            if (Schema::hasColumn('salary_policies', 'absence_deduction_method')) {
                $table->dropColumn('absence_deduction_method');
            }
        });
    }
};
