<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('payroll_items')) {
            Schema::create('payroll_items', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('company_id');
                $table->unsignedBigInteger('payroll_id');
                $table->unsignedBigInteger('employee_id');
                $table->decimal('basic_salary', 10, 2)->default(0);
                $table->integer('working_days')->default(0);
                $table->integer('absent_days')->default(0);
                $table->integer('late_minutes')->default(0);
                $table->decimal('overtime_hours', 8, 2)->default(0);
                $table->decimal('overtime_amount', 10, 2)->default(0);
                $table->json('allowances')->nullable(); // JSON
                $table->json('deductions')->nullable(); // JSON
                $table->decimal('gross_salary', 10, 2)->default(0);
                $table->decimal('tax_amount', 10, 2)->default(0);
                $table->decimal('social_insurance', 10, 2)->default(0);
                $table->decimal('net_salary', 10, 2)->default(0);
                $table->enum('payment_status', ['pending', 'paid'])->default('pending');
                $table->date('payment_date')->nullable();
                $table->text('notes')->nullable();
                $table->unsignedBigInteger('created_by')->nullable();
                $table->unsignedBigInteger('updated_by')->nullable();
                $table->timestamps();

                $table->foreign('company_id')->references('id')->on('companies')->onDelete('cascade');
                $table->foreign('payroll_id')->references('id')->on('payrolls')->onDelete('cascade');
                $table->foreign('employee_id')->references('id')->on('employees')->onDelete('cascade');
                $table->foreign('created_by')->references('id')->on('users')->onDelete('set null');
                $table->foreign('updated_by')->references('id')->on('users')->onDelete('set null');
            });
        } else {
            Schema::table('payroll_items', function (Blueprint $table) {
                if (!Schema::hasColumn('payroll_items', 'working_days')) {
                    $table->integer('working_days')->default(0)->after('basic_salary');
                }
                if (!Schema::hasColumn('payroll_items', 'absent_days')) {
                    $table->integer('absent_days')->default(0)->after('working_days');
                }
                if (!Schema::hasColumn('payroll_items', 'late_minutes')) {
                    $table->integer('late_minutes')->default(0)->after('absent_days');
                }
                if (!Schema::hasColumn('payroll_items', 'overtime_hours')) {
                    $table->decimal('overtime_hours', 8, 2)->default(0)->after('late_minutes');
                }
                if (!Schema::hasColumn('payroll_items', 'overtime_amount')) {
                    $table->decimal('overtime_amount', 10, 2)->default(0)->after('overtime_hours');
                }
                if (!Schema::hasColumn('payroll_items', 'allowances')) {
                    $table->json('allowances')->nullable()->after('overtime_amount');
                }
                if (!Schema::hasColumn('payroll_items', 'deductions')) {
                    $table->json('deductions')->nullable()->after('allowances');
                }
                if (!Schema::hasColumn('payroll_items', 'gross_salary')) {
                    $table->decimal('gross_salary', 10, 2)->default(0)->after('deductions');
                }
                if (!Schema::hasColumn('payroll_items', 'tax_amount')) {
                    $table->decimal('tax_amount', 10, 2)->default(0)->after('gross_salary');
                }
                if (!Schema::hasColumn('payroll_items', 'social_insurance')) {
                    $table->decimal('social_insurance', 10, 2)->default(0)->after('tax_amount');
                }
                if (!Schema::hasColumn('payroll_items', 'payment_status')) {
                    $table->enum('payment_status', ['pending', 'paid'])->default('pending')->after('net_salary');
                }
                if (!Schema::hasColumn('payroll_items', 'payment_date')) {
                    $table->date('payment_date')->nullable()->after('payment_status');
                }
                if (!Schema::hasColumn('payroll_items', 'notes')) {
                    $table->text('notes')->nullable()->after('payment_date');
                }
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasTable('payroll_items')) {
            Schema::table('payroll_items', function (Blueprint $table) {
                $table->dropColumn([
                    'working_days',
                    'absent_days',
                    'late_minutes',
                    'overtime_hours',
                    'overtime_amount',
                    'allowances',
                    'deductions',
                    'gross_salary',
                    'tax_amount',
                    'social_insurance',
                    'payment_status',
                    'payment_date',
                    'notes'
                ]);
            });
        }
    }
};
