<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('payrolls')) {
            Schema::create('payrolls', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('company_id');
                $table->string('payroll_period'); // e.g., "January 2023"
                $table->date('start_date');
                $table->date('end_date');
                $table->integer('total_employees')->default(0);
                $table->decimal('total_basic_salary', 12, 2)->default(0);
                $table->decimal('total_allowances', 12, 2)->default(0);
                $table->decimal('total_deductions', 12, 2)->default(0);
                $table->decimal('total_overtime', 12, 2)->default(0);
                $table->decimal('total_tax', 12, 2)->default(0);
                $table->decimal('total_social_insurance', 12, 2)->default(0);
                $table->decimal('total_net_salary', 12, 2)->default(0);
                $table->enum('status', ['draft', 'approved', 'paid', 'cancelled'])->default('draft');
                $table->date('payment_date')->nullable();
                $table->text('notes')->nullable();
                $table->unsignedBigInteger('created_by')->nullable();
                $table->unsignedBigInteger('updated_by')->nullable();
                $table->timestamps();

                $table->foreign('company_id')->references('id')->on('companies')->onDelete('cascade');
                $table->foreign('created_by')->references('id')->on('users')->onDelete('set null');
                $table->foreign('updated_by')->references('id')->on('users')->onDelete('set null');
            });
        } else {
            Schema::table('payrolls', function (Blueprint $table) {
                if (!Schema::hasColumn('payrolls', 'payroll_period')) {
                    $table->string('payroll_period')->after('company_id'); // e.g., "January 2023"
                }
                if (!Schema::hasColumn('payrolls', 'start_date')) {
                    $table->date('start_date')->after('payroll_period');
                }
                if (!Schema::hasColumn('payrolls', 'end_date')) {
                    $table->date('end_date')->after('start_date');
                }
                if (!Schema::hasColumn('payrolls', 'total_employees')) {
                    $table->integer('total_employees')->default(0)->after('end_date');
                }
                if (!Schema::hasColumn('payrolls', 'total_basic_salary')) {
                    $table->decimal('total_basic_salary', 12, 2)->default(0)->after('total_employees');
                }
                if (!Schema::hasColumn('payrolls', 'total_allowances')) {
                    $table->decimal('total_allowances', 12, 2)->default(0)->after('total_basic_salary');
                }
                if (!Schema::hasColumn('payrolls', 'total_deductions')) {
                    $table->decimal('total_deductions', 12, 2)->default(0)->after('total_allowances');
                }
                if (!Schema::hasColumn('payrolls', 'total_overtime')) {
                    $table->decimal('total_overtime', 12, 2)->default(0)->after('total_deductions');
                }
                if (!Schema::hasColumn('payrolls', 'total_tax')) {
                    $table->decimal('total_tax', 12, 2)->default(0)->after('total_overtime');
                }
                if (!Schema::hasColumn('payrolls', 'total_social_insurance')) {
                    $table->decimal('total_social_insurance', 12, 2)->default(0)->after('total_tax');
                }
                if (!Schema::hasColumn('payrolls', 'total_net_salary')) {
                    $table->decimal('total_net_salary', 12, 2)->default(0)->after('total_social_insurance');
                }
                if (!Schema::hasColumn('payrolls', 'status')) {
                    $table->enum('status', ['draft', 'approved', 'paid', 'cancelled'])->default('draft')->after('total_net_salary');
                }
                if (!Schema::hasColumn('payrolls', 'payment_date')) {
                    $table->date('payment_date')->nullable()->after('status');
                }
                if (!Schema::hasColumn('payrolls', 'notes')) {
                    $table->text('notes')->nullable()->after('payment_date');
                }
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasTable('payrolls')) {
            Schema::table('payrolls', function (Blueprint $table) {
                $table->dropColumn([
                    'payroll_period',
                    'start_date',
                    'end_date',
                    'total_employees',
                    'total_basic_salary',
                    'total_allowances',
                    'total_deductions',
                    'total_overtime',
                    'total_tax',
                    'total_social_insurance',
                    'total_net_salary',
                    'status',
                    'payment_date',
                    'notes'
                ]);
            });
        }
    }
};
