<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('salary_policies', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('company_id');
            $table->decimal('late_deduction_rate', 5, 2)->default(0); // نسبة خصم التأخير
            $table->decimal('absence_deduction_rate', 5, 2)->default(0); // نسبة خصم الغياب
            $table->decimal('overtime_rate_weekday', 5, 2)->default(1.5); // معدل العمل الإضافي في أيام العمل
            $table->decimal('overtime_rate_weekend', 5, 2)->default(2.0); // معدل العمل الإضافي في عطلة نهاية الأسبوع
            $table->decimal('overtime_rate_holiday', 5, 2)->default(2.5); // معدل العمل الإضافي في الإجازات الرسمية
            $table->enum('tax_calculation_method', ['progressive', 'flat'])->default('progressive'); // طريقة حساب الضريبة
            $table->decimal('social_insurance_employee_percentage', 5, 2)->default(0); // نسبة التأمينات الاجتماعية للموظف
            $table->decimal('social_insurance_company_percentage', 5, 2)->default(0); // نسبة التأمينات الاجتماعية للشركة
            $table->integer('allowed_late_minutes')->default(0); // الدقائق المسموح بها للتأخير
            $table->boolean('calculate_overtime')->default(true); // حساب العمل الإضافي
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->timestamps();

            $table->foreign('company_id')->references('id')->on('companies')->onDelete('cascade');
            $table->foreign('created_by')->references('id')->on('users')->onDelete('set null');
            $table->foreign('updated_by')->references('id')->on('users')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('salary_policies');
    }
};
