<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('salary_components', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('company_id');
            $table->unsignedBigInteger('salary_id');
            $table->string('name');
            $table->enum('type', ['allowance', 'deduction', 'bonus', 'overtime'])->default('allowance');
            $table->decimal('amount', 10, 2)->default(0);
            $table->boolean('is_percentage')->default(false);
            $table->enum('percentage_of', ['basic', 'gross'])->nullable();
            $table->boolean('is_taxable')->default(true);
            $table->boolean('is_fixed')->default(true);
            $table->enum('frequency', ['monthly', 'quarterly', 'annual', 'one-time'])->default('monthly');
            $table->date('effective_date')->nullable();
            $table->date('expiry_date')->nullable();
            $table->enum('status', ['active', 'inactive'])->default('active');
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->timestamps();

            $table->foreign('company_id')->references('id')->on('companies')->onDelete('cascade');
            $table->foreign('salary_id')->references('id')->on('salaries')->onDelete('cascade');
            $table->foreign('created_by')->references('id')->on('users')->onDelete('set null');
            $table->foreign('updated_by')->references('id')->on('users')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('salary_components');
    }
};
