<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('salaries', function (Blueprint $table) {
            if (!Schema::hasColumn('salaries', 'housing_allowance')) {
                $table->decimal('housing_allowance', 10, 2)->default(0);
            }
            if (!Schema::hasColumn('salaries', 'transportation_allowance')) {
                $table->decimal('transportation_allowance', 10, 2)->default(0);
            }
            if (!Schema::hasColumn('salaries', 'other_allowances')) {
                $table->decimal('other_allowances', 10, 2)->default(0);
            }
            if (!Schema::hasColumn('salaries', 'total_allowances')) {
                $table->decimal('total_allowances', 10, 2)->default(0);
            }
            if (!Schema::hasColumn('salaries', 'gross_salary')) {
                $table->decimal('gross_salary', 10, 2)->default(0);
            }
            if (!Schema::hasColumn('salaries', 'tax_deduction')) {
                $table->decimal('tax_deduction', 10, 2)->default(0);
            }
            if (!Schema::hasColumn('salaries', 'social_insurance')) {
                $table->decimal('social_insurance', 10, 2)->default(0);
            }
            if (!Schema::hasColumn('salaries', 'other_deductions')) {
                $table->decimal('other_deductions', 10, 2)->default(0);
            }
            if (!Schema::hasColumn('salaries', 'total_deductions')) {
                $table->decimal('total_deductions', 10, 2)->default(0);
            }
            if (!Schema::hasColumn('salaries', 'net_salary')) {
                $table->decimal('net_salary', 10, 2)->default(0);
            }
            if (!Schema::hasColumn('salaries', 'effective_date')) {
                $table->date('effective_date')->nullable();
            }
            if (!Schema::hasColumn('salaries', 'status')) {
                $table->enum('status', ['active', 'inactive'])->default('active');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('salaries', function (Blueprint $table) {
            $table->dropColumn([
                'housing_allowance',
                'transportation_allowance',
                'other_allowances',
                'total_allowances',
                'gross_salary',
                'tax_deduction',
                'social_insurance',
                'other_deductions',
                'total_deductions',
                'net_salary',
                'effective_date',
                'status'
            ]);
        });
    }
};
