<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('project_issues', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('installation_project_id');
            $table->unsignedBigInteger('project_phase_id')->nullable();
            $table->unsignedBigInteger('project_elevator_id')->nullable();
            $table->string('title');
            $table->text('description')->nullable();
            $table->string('issue_type')->default('technical');
            $table->string('priority')->default('medium');
            $table->string('status')->default('open');
            $table->unsignedBigInteger('reported_by');
            $table->unsignedBigInteger('assigned_to')->nullable();
            $table->date('reported_date')->nullable();
            $table->date('due_date')->nullable();
            $table->date('resolution_date')->nullable();
            $table->text('resolution')->nullable();
            $table->text('impact')->nullable();
            $table->text('root_cause')->nullable();
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->text('notes')->nullable();
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('installation_project_id')->references('id')->on('installation_projects')->onDelete('cascade');
            $table->foreign('project_phase_id')->references('id')->on('project_phases')->onDelete('set null');
            $table->foreign('project_elevator_id')->references('id')->on('project_elevators')->onDelete('set null');
            $table->foreign('reported_by')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('assigned_to')->references('id')->on('users')->onDelete('set null');
            $table->foreign('created_by')->references('id')->on('users')->onDelete('set null');
            $table->foreign('updated_by')->references('id')->on('users')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('project_issues');
    }
};
