<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('project_documents', function (Blueprint $table) {
            // إضافة حقل soft delete إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_documents', 'deleted_at')) {
                $table->softDeletes();
            }

            // إضافة حقل category إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_documents', 'category')) {
                $table->string('category')->nullable();
            }

            // إضافة حقل is_public إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_documents', 'is_public')) {
                $table->boolean('is_public')->default(false);
            }

            // إضافة حقل approved_by إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_documents', 'approved_by')) {
                $table->unsignedBigInteger('approved_by')->nullable();
                $table->foreign('approved_by')->references('id')->on('users')->onDelete('set null');
            }

            // إضافة حقل approved_at إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_documents', 'approved_at')) {
                $table->timestamp('approved_at')->nullable();
            }

            // إضافة حقل created_by إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_documents', 'created_by')) {
                $table->unsignedBigInteger('created_by')->nullable();
                $table->foreign('created_by')->references('id')->on('users')->onDelete('set null');
            }

            // إضافة حقل updated_by إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_documents', 'updated_by')) {
                $table->unsignedBigInteger('updated_by')->nullable();
                $table->foreign('updated_by')->references('id')->on('users')->onDelete('set null');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('project_documents', function (Blueprint $table) {
            // حذف الحقول المضافة
            if (Schema::hasColumn('project_documents', 'deleted_at')) {
                $table->dropSoftDeletes();
            }

            if (Schema::hasColumn('project_documents', 'category')) {
                $table->dropColumn('category');
            }

            if (Schema::hasColumn('project_documents', 'is_public')) {
                $table->dropColumn('is_public');
            }

            if (Schema::hasColumn('project_documents', 'approved_by')) {
                $table->dropForeign(['approved_by']);
                $table->dropColumn('approved_by');
            }

            if (Schema::hasColumn('project_documents', 'approved_at')) {
                $table->dropColumn('approved_at');
            }

            if (Schema::hasColumn('project_documents', 'created_by')) {
                $table->dropForeign(['created_by']);
                $table->dropColumn('created_by');
            }

            if (Schema::hasColumn('project_documents', 'updated_by')) {
                $table->dropForeign(['updated_by']);
                $table->dropColumn('updated_by');
            }
        });
    }
};
