<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('project_checklist_items', function (Blueprint $table) {
            // إضافة حقل soft delete إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_checklist_items', 'deleted_at')) {
                $table->softDeletes();
            }

            // إضافة حقل is_required إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_checklist_items', 'is_required')) {
                $table->boolean('is_required')->default(true);
            }

            // إضافة حقل created_by إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_checklist_items', 'created_by')) {
                $table->unsignedBigInteger('created_by')->nullable();
                $table->foreign('created_by')->references('id')->on('users')->onDelete('set null');
            }

            // إضافة حقل updated_by إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_checklist_items', 'updated_by')) {
                $table->unsignedBigInteger('updated_by')->nullable();
                $table->foreign('updated_by')->references('id')->on('users')->onDelete('set null');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('project_checklist_items', function (Blueprint $table) {
            // حذف الحقول المضافة
            if (Schema::hasColumn('project_checklist_items', 'deleted_at')) {
                $table->dropSoftDeletes();
            }

            if (Schema::hasColumn('project_checklist_items', 'is_required')) {
                $table->dropColumn('is_required');
            }

            if (Schema::hasColumn('project_checklist_items', 'created_by')) {
                $table->dropForeign(['created_by']);
                $table->dropColumn('created_by');
            }

            if (Schema::hasColumn('project_checklist_items', 'updated_by')) {
                $table->dropForeign(['updated_by']);
                $table->dropColumn('updated_by');
            }
        });
    }
};
