<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('project_checklists', function (Blueprint $table) {
            // إضافة حقل soft delete إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_checklists', 'deleted_at')) {
                $table->softDeletes();
            }

            // إضافة حقل category إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_checklists', 'category')) {
                $table->string('category')->nullable();
            }

            // إضافة حقل priority إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_checklists', 'priority')) {
                $table->string('priority')->default('medium');
            }

            // إضافة حقل due_date إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_checklists', 'due_date')) {
                $table->date('due_date')->nullable();
            }

            // إضافة حقل updated_by إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_checklists', 'updated_by')) {
                $table->unsignedBigInteger('updated_by')->nullable();
                $table->foreign('updated_by')->references('id')->on('users')->onDelete('set null');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('project_checklists', function (Blueprint $table) {
            // حذف الحقول المضافة
            if (Schema::hasColumn('project_checklists', 'deleted_at')) {
                $table->dropSoftDeletes();
            }

            if (Schema::hasColumn('project_checklists', 'category')) {
                $table->dropColumn('category');
            }

            if (Schema::hasColumn('project_checklists', 'priority')) {
                $table->dropColumn('priority');
            }

            if (Schema::hasColumn('project_checklists', 'due_date')) {
                $table->dropColumn('due_date');
            }

            if (Schema::hasColumn('project_checklists', 'updated_by')) {
                $table->dropForeign(['updated_by']);
                $table->dropColumn('updated_by');
            }
        });
    }
};
