<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('project_milestones', function (Blueprint $table) {
            // إضافة حقل soft delete إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_milestones', 'deleted_at')) {
                $table->softDeletes();
            }

            // إضافة حقل project_phase_id إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_milestones', 'project_phase_id')) {
                $table->unsignedBigInteger('project_phase_id')->nullable();
                $table->foreign('project_phase_id')->references('id')->on('project_phases')->onDelete('set null');
            }

            // إضافة حقل priority إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_milestones', 'priority')) {
                $table->string('priority')->default('medium');
            }

            // إضافة حقل is_key_milestone إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_milestones', 'is_key_milestone')) {
                $table->boolean('is_key_milestone')->default(false);
            }

            // إضافة حقل completion_criteria إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_milestones', 'completion_criteria')) {
                $table->text('completion_criteria')->nullable();
            }

            // إضافة حقل created_by إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_milestones', 'created_by')) {
                $table->unsignedBigInteger('created_by')->nullable();
                $table->foreign('created_by')->references('id')->on('users')->onDelete('set null');
            }

            // إضافة حقل updated_by إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_milestones', 'updated_by')) {
                $table->unsignedBigInteger('updated_by')->nullable();
                $table->foreign('updated_by')->references('id')->on('users')->onDelete('set null');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('project_milestones', function (Blueprint $table) {
            // حذف الحقول المضافة
            if (Schema::hasColumn('project_milestones', 'deleted_at')) {
                $table->dropSoftDeletes();
            }

            if (Schema::hasColumn('project_milestones', 'project_phase_id')) {
                $table->dropForeign(['project_phase_id']);
                $table->dropColumn('project_phase_id');
            }

            if (Schema::hasColumn('project_milestones', 'priority')) {
                $table->dropColumn('priority');
            }

            if (Schema::hasColumn('project_milestones', 'is_key_milestone')) {
                $table->dropColumn('is_key_milestone');
            }

            if (Schema::hasColumn('project_milestones', 'completion_criteria')) {
                $table->dropColumn('completion_criteria');
            }

            if (Schema::hasColumn('project_milestones', 'created_by')) {
                $table->dropForeign(['created_by']);
                $table->dropColumn('created_by');
            }

            if (Schema::hasColumn('project_milestones', 'updated_by')) {
                $table->dropForeign(['updated_by']);
                $table->dropColumn('updated_by');
            }
        });
    }
};
