<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('project_report_attachments', function (Blueprint $table) {
            // إضافة حقل soft delete إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_report_attachments', 'deleted_at')) {
                $table->softDeletes();
            }

            // إضافة حقل description إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_report_attachments', 'description')) {
                $table->text('description')->nullable();
            }

            // إضافة حقل uploaded_by إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_report_attachments', 'uploaded_by')) {
                $table->unsignedBigInteger('uploaded_by')->nullable();
                $table->foreign('uploaded_by')->references('id')->on('users')->onDelete('set null');
            }

            // تغيير اسم الحقل من project_report_id إلى report_id إذا لم يكن موجوداً
            if (Schema::hasColumn('project_report_attachments', 'project_report_id') && !Schema::hasColumn('project_report_attachments', 'report_id')) {
                $table->renameColumn('project_report_id', 'report_id');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('project_report_attachments', function (Blueprint $table) {
            // حذف الحقول المضافة
            if (Schema::hasColumn('project_report_attachments', 'deleted_at')) {
                $table->dropSoftDeletes();
            }

            if (Schema::hasColumn('project_report_attachments', 'description')) {
                $table->dropColumn('description');
            }

            if (Schema::hasColumn('project_report_attachments', 'uploaded_by')) {
                $table->dropForeign(['uploaded_by']);
                $table->dropColumn('uploaded_by');
            }

            // إعادة اسم الحقل من report_id إلى project_report_id
            if (Schema::hasColumn('project_report_attachments', 'report_id') && !Schema::hasColumn('project_report_attachments', 'project_report_id')) {
                $table->renameColumn('report_id', 'project_report_id');
            }
        });
    }
};
