<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('project_reports', function (Blueprint $table) {
            // إضافة حقل status إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_reports', 'status')) {
                $table->string('status')->default('draft');
            }

            // إضافة حقل approved_by إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_reports', 'approved_by')) {
                $table->unsignedBigInteger('approved_by')->nullable();
                $table->foreign('approved_by')->references('id')->on('users')->onDelete('set null');
            }

            // إضافة حقل approved_at إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_reports', 'approved_at')) {
                $table->timestamp('approved_at')->nullable();
            }

            // إضافة حقل updated_by إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_reports', 'updated_by')) {
                $table->unsignedBigInteger('updated_by')->nullable();
                $table->foreign('updated_by')->references('id')->on('users')->onDelete('set null');
            }

            // تغيير اسم الحقل من report_type إلى type إذا لم يكن موجوداً
            if (Schema::hasColumn('project_reports', 'report_type') && !Schema::hasColumn('project_reports', 'type')) {
                $table->renameColumn('report_type', 'type');
            }

            // تغيير اسم الحقل من description إلى content إذا لم يكن موجوداً
            if (Schema::hasColumn('project_reports', 'description') && !Schema::hasColumn('project_reports', 'content')) {
                $table->renameColumn('description', 'content');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('project_reports', function (Blueprint $table) {
            // حذف الحقول المضافة
            if (Schema::hasColumn('project_reports', 'status')) {
                $table->dropColumn('status');
            }

            if (Schema::hasColumn('project_reports', 'approved_by')) {
                $table->dropForeign(['approved_by']);
                $table->dropColumn('approved_by');
            }

            if (Schema::hasColumn('project_reports', 'approved_at')) {
                $table->dropColumn('approved_at');
            }

            if (Schema::hasColumn('project_reports', 'updated_by')) {
                $table->dropForeign(['updated_by']);
                $table->dropColumn('updated_by');
            }

            // إعادة اسم الحقل من type إلى report_type
            if (Schema::hasColumn('project_reports', 'type') && !Schema::hasColumn('project_reports', 'report_type')) {
                $table->renameColumn('type', 'report_type');
            }

            // إعادة اسم الحقل من content إلى description
            if (Schema::hasColumn('project_reports', 'content') && !Schema::hasColumn('project_reports', 'description')) {
                $table->renameColumn('content', 'description');
            }
        });
    }
};
