<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('project_risks', function (Blueprint $table) {
            // إضافة حقل contingency_plan إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_risks', 'contingency_plan')) {
                $table->text('contingency_plan')->nullable();
            }

            // إضافة حقل created_by إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_risks', 'created_by')) {
                $table->unsignedBigInteger('created_by')->nullable();
                $table->foreign('created_by')->references('id')->on('users')->onDelete('set null');
            }

            // إضافة حقل updated_by إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_risks', 'updated_by')) {
                $table->unsignedBigInteger('updated_by')->nullable();
                $table->foreign('updated_by')->references('id')->on('users')->onDelete('set null');
            }

            // تغيير اسم الحقل من identification_date إلى identified_date إذا لم يكن موجوداً
            if (Schema::hasColumn('project_risks', 'identification_date') && !Schema::hasColumn('project_risks', 'identified_date')) {
                $table->renameColumn('identification_date', 'identified_date');
            }

            // تغيير اسم الحقل من responsible_user_id إلى owner_id إذا لم يكن موجوداً
            if (Schema::hasColumn('project_risks', 'responsible_user_id') && !Schema::hasColumn('project_risks', 'owner_id')) {
                $table->renameColumn('responsible_user_id', 'owner_id');
            }

            // تغيير اسم الحقل من actual_resolution_date إلى resolution_date إذا لم يكن موجوداً
            if (Schema::hasColumn('project_risks', 'actual_resolution_date') && !Schema::hasColumn('project_risks', 'resolution_date')) {
                $table->renameColumn('actual_resolution_date', 'resolution_date');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('project_risks', function (Blueprint $table) {
            // حذف الحقول المضافة
            if (Schema::hasColumn('project_risks', 'contingency_plan')) {
                $table->dropColumn('contingency_plan');
            }

            if (Schema::hasColumn('project_risks', 'created_by')) {
                $table->dropForeign(['created_by']);
                $table->dropColumn('created_by');
            }

            if (Schema::hasColumn('project_risks', 'updated_by')) {
                $table->dropForeign(['updated_by']);
                $table->dropColumn('updated_by');
            }

            // إعادة اسم الحقل من identified_date إلى identification_date
            if (Schema::hasColumn('project_risks', 'identified_date') && !Schema::hasColumn('project_risks', 'identification_date')) {
                $table->renameColumn('identified_date', 'identification_date');
            }

            // إعادة اسم الحقل من owner_id إلى responsible_user_id
            if (Schema::hasColumn('project_risks', 'owner_id') && !Schema::hasColumn('project_risks', 'responsible_user_id')) {
                $table->renameColumn('owner_id', 'responsible_user_id');
            }

            // إعادة اسم الحقل من resolution_date إلى actual_resolution_date
            if (Schema::hasColumn('project_risks', 'resolution_date') && !Schema::hasColumn('project_risks', 'actual_resolution_date')) {
                $table->renameColumn('resolution_date', 'actual_resolution_date');
            }
        });
    }
};
