<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('project_resource_allocations', function (Blueprint $table) {
            // إضافة حقل status إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_resource_allocations', 'status')) {
                $table->string('status')->default('planned');
            }

            // إضافة حقل allocated_by إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_resource_allocations', 'allocated_by')) {
                $table->unsignedBigInteger('allocated_by')->nullable();
                $table->foreign('allocated_by')->references('id')->on('users')->onDelete('set null');
            }

            // إضافة حقل created_by إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_resource_allocations', 'created_by')) {
                $table->unsignedBigInteger('created_by')->nullable();
                $table->foreign('created_by')->references('id')->on('users')->onDelete('set null');
            }

            // إضافة حقل updated_by إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_resource_allocations', 'updated_by')) {
                $table->unsignedBigInteger('updated_by')->nullable();
                $table->foreign('updated_by')->references('id')->on('users')->onDelete('set null');
            }

            // تغيير اسم الحقل من project_resource_id إلى resource_id إذا لم يكن موجوداً
            if (Schema::hasColumn('project_resource_allocations', 'project_resource_id') && !Schema::hasColumn('project_resource_allocations', 'resource_id')) {
                $table->renameColumn('project_resource_id', 'resource_id');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('project_resource_allocations', function (Blueprint $table) {
            // حذف الحقول المضافة
            if (Schema::hasColumn('project_resource_allocations', 'status')) {
                $table->dropColumn('status');
            }

            if (Schema::hasColumn('project_resource_allocations', 'allocated_by')) {
                $table->dropForeign(['allocated_by']);
                $table->dropColumn('allocated_by');
            }

            if (Schema::hasColumn('project_resource_allocations', 'created_by')) {
                $table->dropForeign(['created_by']);
                $table->dropColumn('created_by');
            }

            if (Schema::hasColumn('project_resource_allocations', 'updated_by')) {
                $table->dropForeign(['updated_by']);
                $table->dropColumn('updated_by');
            }

            // إعادة اسم الحقل من resource_id إلى project_resource_id
            if (Schema::hasColumn('project_resource_allocations', 'resource_id') && !Schema::hasColumn('project_resource_allocations', 'project_resource_id')) {
                $table->renameColumn('resource_id', 'project_resource_id');
            }
        });
    }
};
