<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('project_resources', function (Blueprint $table) {
            // إضافة حقل status إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_resources', 'status')) {
                $table->string('status')->default('available');
            }

            // إضافة حقل inventory_item_id إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_resources', 'inventory_item_id')) {
                $table->unsignedBigInteger('inventory_item_id')->nullable();
                $table->foreign('inventory_item_id')->references('id')->on('inventory_items')->onDelete('set null');
            }

            // إضافة حقل created_by إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_resources', 'created_by')) {
                $table->unsignedBigInteger('created_by')->nullable();
                $table->foreign('created_by')->references('id')->on('users')->onDelete('set null');
            }

            // إضافة حقل updated_by إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_resources', 'updated_by')) {
                $table->unsignedBigInteger('updated_by')->nullable();
                $table->foreign('updated_by')->references('id')->on('users')->onDelete('set null');
            }

            // تغيير اسم الحقل من supplier_id إلى inventory_supplier_id إذا لم يكن موجوداً
            if (Schema::hasColumn('project_resources', 'supplier_id') && !Schema::hasColumn('project_resources', 'inventory_supplier_id')) {
                $table->renameColumn('supplier_id', 'inventory_supplier_id');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('project_resources', function (Blueprint $table) {
            // حذف الحقول المضافة
            if (Schema::hasColumn('project_resources', 'status')) {
                $table->dropColumn('status');
            }

            if (Schema::hasColumn('project_resources', 'inventory_item_id')) {
                $table->dropForeign(['inventory_item_id']);
                $table->dropColumn('inventory_item_id');
            }

            if (Schema::hasColumn('project_resources', 'created_by')) {
                $table->dropForeign(['created_by']);
                $table->dropColumn('created_by');
            }

            if (Schema::hasColumn('project_resources', 'updated_by')) {
                $table->dropForeign(['updated_by']);
                $table->dropColumn('updated_by');
            }

            // إعادة اسم الحقل من inventory_supplier_id إلى supplier_id
            if (Schema::hasColumn('project_resources', 'inventory_supplier_id') && !Schema::hasColumn('project_resources', 'supplier_id')) {
                $table->renameColumn('inventory_supplier_id', 'supplier_id');
            }
        });
    }
};
