<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('project_task_dependencies', function (Blueprint $table) {
            // إضافة حقل soft delete إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_task_dependencies', 'deleted_at')) {
                $table->softDeletes();
            }

            // إضافة حقل created_by إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_task_dependencies', 'created_by')) {
                $table->unsignedBigInteger('created_by')->nullable();
                $table->foreign('created_by')->references('id')->on('users')->onDelete('set null');
            }

            // إضافة حقل updated_by إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_task_dependencies', 'updated_by')) {
                $table->unsignedBigInteger('updated_by')->nullable();
                $table->foreign('updated_by')->references('id')->on('users')->onDelete('set null');
            }

            // إضافة حقل description إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_task_dependencies', 'description')) {
                $table->text('description')->nullable();
            }

            // إضافة حقل is_critical إذا لم يكن موجوداً
            if (!Schema::hasColumn('project_task_dependencies', 'is_critical')) {
                $table->boolean('is_critical')->default(false);
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('project_task_dependencies', function (Blueprint $table) {
            // حذف الحقول المضافة
            if (Schema::hasColumn('project_task_dependencies', 'deleted_at')) {
                $table->dropSoftDeletes();
            }

            if (Schema::hasColumn('project_task_dependencies', 'created_by')) {
                $table->dropForeign(['created_by']);
                $table->dropColumn('created_by');
            }

            if (Schema::hasColumn('project_task_dependencies', 'updated_by')) {
                $table->dropForeign(['updated_by']);
                $table->dropColumn('updated_by');
            }

            if (Schema::hasColumn('project_task_dependencies', 'description')) {
                $table->dropColumn('description');
            }

            if (Schema::hasColumn('project_task_dependencies', 'is_critical')) {
                $table->dropColumn('is_critical');
            }
        });
    }
};
