<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('project_inventory_request_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('project_inventory_request_id');
            $table->foreign('project_inventory_request_id', 'pir_request_id_foreign')
                ->references('id')
                ->on('project_inventory_requests')
                ->onDelete('cascade');
            $table->foreignId('inventory_item_id')->constrained('inventory_items');
            $table->foreignId('warehouse_id')->constrained('warehouses');
            $table->decimal('quantity', 10, 2);
            $table->decimal('fulfilled_quantity', 10, 2)->default(0);
            $table->enum('status', ['pending', 'approved', 'partially_fulfilled', 'fulfilled', 'rejected'])->default('pending');
            $table->text('notes')->nullable();
            $table->text('rejection_reason')->nullable();
            $table->enum('priority', ['low', 'medium', 'high', 'critical'])->default('medium');
            $table->foreignId('task_id')->nullable()->constrained('project_tasks');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('project_inventory_request_items');
    }
};
