<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('project_inventory_requests', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained('companies');
            $table->foreignId('installation_project_id')->constrained('installation_projects');
            $table->foreignId('project_phase_id')->nullable()->constrained('project_phases');
            $table->string('request_number')->unique();
            $table->enum('status', ['draft', 'pending', 'approved', 'partially_fulfilled', 'fulfilled', 'rejected'])->default('draft');
            $table->foreignId('requested_by')->constrained('users');
            $table->foreignId('approved_by')->nullable()->constrained('users');
            $table->dateTime('requested_date');
            $table->dateTime('required_date');
            $table->dateTime('approval_date')->nullable();
            $table->dateTime('fulfillment_date')->nullable();
            $table->text('notes')->nullable();
            $table->text('rejection_reason')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('project_inventory_requests');
    }
};
