<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('installation_projects', function (Blueprint $table) {
            // تعديل عمود project_manager_id ليقبل القيمة NULL
            $table->unsignedBigInteger('project_manager_id')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('installation_projects', function (Blueprint $table) {
            // إعادة عمود project_manager_id إلى حالته السابقة (غير قابل للقيمة NULL)
            $table->unsignedBigInteger('project_manager_id')->nullable(false)->change();
        });
    }
};
