<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('maintenance_logs', function (Blueprint $table) {
            // إضافة عمود deleted_at إذا لم يكن موجودًا
            if (!Schema::hasColumn('maintenance_logs', 'deleted_at')) {
                $table->softDeletes();
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('maintenance_logs', function (Blueprint $table) {
            // حذف عمود deleted_at إذا كان موجودًا
            if (Schema::hasColumn('maintenance_logs', 'deleted_at')) {
                $table->dropSoftDeletes();
            }
        });
    }
};
