<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payroll_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('payroll_id')->constrained('payrolls')->onDelete('cascade');
            $table->foreignId('employee_id')->constrained('employees')->onDelete('cascade');
            $table->decimal('basic_salary', 12, 2)->default(0)->comment('الراتب الأساسي');
            $table->json('allowances')->nullable()->comment('البدلات (JSON)');
            $table->decimal('total_allowances', 12, 2)->default(0)->comment('إجمالي البدلات');
            $table->json('deductions')->nullable()->comment('الخصومات (JSON)');
            $table->decimal('total_deductions', 12, 2)->default(0)->comment('إجمالي الخصومات');
            $table->decimal('net_salary', 12, 2)->default(0)->comment('صافي الراتب');
            $table->integer('working_days')->default(0)->comment('أيام العمل');
            $table->integer('present_days')->default(0)->comment('أيام الحضور');
            $table->integer('absent_days')->default(0)->comment('أيام الغياب');
            $table->integer('leave_days')->default(0)->comment('أيام الإجازة');
            $table->integer('late_minutes')->default(0)->comment('دقائق التأخير');
            $table->decimal('late_deduction', 12, 2)->default(0)->comment('خصم التأخير');
            $table->decimal('overtime_hours', 8, 2)->default(0)->comment('ساعات العمل الإضافي');
            $table->decimal('overtime_amount', 12, 2)->default(0)->comment('مبلغ العمل الإضافي');
            $table->text('notes')->nullable()->comment('ملاحظات');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payroll_items');
    }
};
