<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payrolls', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained('companies')->onDelete('cascade');
            $table->string('payroll_period')->comment('فترة الراتب (مثال: يناير 2023)');
            $table->date('start_date')->comment('تاريخ بداية فترة الراتب');
            $table->date('end_date')->comment('تاريخ نهاية فترة الراتب');
            $table->date('payment_date')->comment('تاريخ دفع الرواتب');
            $table->enum('status', ['draft', 'processing', 'approved', 'paid', 'cancelled'])->default('draft')->comment('حالة كشف الراتب');
            $table->decimal('total_basic_salary', 12, 2)->default(0)->comment('إجمالي الراتب الأساسي');
            $table->decimal('total_allowances', 12, 2)->default(0)->comment('إجمالي البدلات');
            $table->decimal('total_deductions', 12, 2)->default(0)->comment('إجمالي الخصومات');
            $table->decimal('total_net_salary', 12, 2)->default(0)->comment('إجمالي صافي الراتب');
            $table->text('notes')->nullable()->comment('ملاحظات');
            $table->foreignId('created_by')->nullable()->constrained('users')->onDelete('set null');
            $table->foreignId('updated_by')->nullable()->constrained('users')->onDelete('set null');
            $table->foreignId('approved_by')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamp('approved_at')->nullable()->comment('تاريخ الاعتماد');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payrolls');
    }
};
