<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('purchase_orders', function (Blueprint $table) {
            $table->foreignId('auto_purchase_rule_id')->nullable()->after('warehouse_id')
                ->constrained('auto_purchase_rules')->nullOnDelete();
            $table->boolean('is_auto_generated')->default(false)->after('auto_purchase_rule_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('purchase_orders', function (Blueprint $table) {
            $table->dropConstrainedForeignId('auto_purchase_rule_id');
            $table->dropColumn('is_auto_generated');
        });
    }
};
