<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('elevators', function (Blueprint $table) {
            // تعديل عمود location_id ليكون قابلاً للقيمة الفارغة
            $table->unsignedBigInteger('location_id')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('elevators', function (Blueprint $table) {
            // إعادة عمود location_id إلى حالته الأصلية (غير قابل للقيمة الفارغة)
            $table->unsignedBigInteger('location_id')->nullable(false)->change();
        });
    }
};
