<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('customers', function (Blueprint $table) {
            $table->enum('status', ['active', 'inactive', 'lead', 'prospect'])->default('active')->after('type');
            $table->string('contact_phone')->nullable()->after('contact_person');
            $table->string('contact_position')->nullable()->after('contact_phone');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('customers', function (Blueprint $table) {
            $table->dropColumn('status');
            $table->dropColumn('contact_phone');
            $table->dropColumn('contact_position');
        });
    }
};
