<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('maintenance_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('maintenance_schedule_id')->nullable()->constrained('maintenance_schedules');
            $table->foreignId('elevator_id')->constrained('elevators');
            $table->date('maintenance_date');
            $table->foreignId('technician_id')->constrained('users');
            $table->string('status'); // completed, partial, failed
            $table->text('issues_found')->nullable();
            $table->text('actions_taken')->nullable();
            $table->text('parts_replaced')->nullable();
            $table->text('next_maintenance_recommendation')->nullable();
            $table->foreignId('company_id')->constrained('companies');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('maintenance_logs');
    }
};
