<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('maintenance_schedules', function (Blueprint $table) {
            $table->id();
            $table->foreignId('maintenance_contract_id')->constrained('maintenance_contracts');
            $table->foreignId('elevator_id')->constrained('elevators');
            $table->date('scheduled_date');
            $table->string('status'); // scheduled, completed, missed, cancelled
            $table->text('notes')->nullable();
            $table->foreignId('company_id')->constrained('companies');
            $table->foreignId('user_id')->constrained('users'); // User who created the schedule
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('maintenance_schedules');
    }
};
