<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('elevator_maintenance_schedules', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained()->onDelete('cascade');
            $table->foreignId('elevator_id')->constrained()->onDelete('cascade');
            $table->string('maintenance_type');
            $table->text('description');
            $table->enum('frequency', ['daily', 'weekly', 'monthly', 'quarterly', 'semi_annual', 'annual']);
            $table->tinyInteger('day_of_week')->nullable()->comment('0-6 (Sunday-Saturday)');
            $table->tinyInteger('day_of_month')->nullable()->comment('1-31');
            $table->tinyInteger('month_of_year')->nullable()->comment('1-12');
            $table->date('start_date');
            $table->date('end_date')->nullable();
            $table->date('last_run_date')->nullable();
            $table->date('next_run_date');
            $table->foreignId('technician_id')->constrained('users')->onDelete('cascade');
            $table->integer('estimated_duration')->comment('in minutes');
            $table->enum('status', ['active', 'inactive', 'completed'])->default('active');
            $table->foreignId('created_by')->constrained('users')->onDelete('cascade');
            $table->text('notes')->nullable();
            $table->timestamps();
        });

        // Add schedule_id to elevator_maintenances table
        Schema::table('elevator_maintenances', function (Blueprint $table) {
            $table->foreignId('schedule_id')->nullable()->after('elevator_id')->constrained('elevator_maintenance_schedules')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Remove schedule_id from elevator_maintenances table
        Schema::table('elevator_maintenances', function (Blueprint $table) {
            $table->dropForeign(['schedule_id']);
            $table->dropColumn('schedule_id');
        });

        Schema::dropIfExists('elevator_maintenance_schedules');
    }
};
