<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (Schema::hasTable('inventory_items')) {
            Schema::table('inventory_items', function (Blueprint $table) {
                // إضافة حقل للوحدة الأساسية
                $table->foreignId('base_unit_id')->nullable()->after('unit')
                    ->constrained('inventory_units')->onDelete('restrict');

                // تعديل حقل الوحدة ليكون اختياري قبل إزالته في المستقبل
                $table->string('unit')->nullable()->change();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasTable('inventory_items')) {
            Schema::table('inventory_items', function (Blueprint $table) {
                $table->dropForeign(['base_unit_id']);
                $table->dropColumn('base_unit_id');
                $table->string('unit')->default('piece')->change();
            });
        }
    }
};
