<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('inventory_item_units')) {
            Schema::create('inventory_item_units', function (Blueprint $table) {
                $table->id();
                $table->foreignId('item_id')->constrained('inventory_items')->onDelete('cascade');
                $table->foreignId('unit_id')->constrained('inventory_units')->onDelete('cascade');
                $table->decimal('conversion_factor', 10, 4)->default(1); // معامل التحويل من الوحدة الأساسية
                $table->boolean('is_default')->default(false); // هل هي الوحدة الافتراضية للصنف
                $table->boolean('is_purchase_unit')->default(false); // هل تستخدم للشراء
                $table->boolean('is_sales_unit')->default(false); // هل تستخدم للبيع
                $table->boolean('is_inventory_unit')->default(false); // هل تستخدم للمخزون
                $table->decimal('purchase_price', 10, 2)->default(0); // سعر الشراء لهذه الوحدة
                $table->decimal('selling_price', 10, 2)->default(0); // سعر البيع لهذه الوحدة
                $table->timestamps();

                // لا يمكن تكرار نفس الوحدة للصنف الواحد
                $table->unique(['item_id', 'unit_id']);
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('inventory_item_units');
    }
};
