<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('inventory_units')) {
            Schema::create('inventory_units', function (Blueprint $table) {
                $table->id();
                $table->foreignId('company_id')->constrained()->onDelete('cascade');
                $table->string('name');                // اسم الوحدة بالعربية
                $table->string('name_en')->nullable(); // اسم الوحدة بالإنجليزية
                $table->string('code')->unique();      // رمز الوحدة
                $table->text('description')->nullable(); // وصف الوحدة
                $table->boolean('is_base')->default(false); // هل هي وحدة أساسية
                $table->boolean('is_active')->default(true); // هل الوحدة نشطة
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('inventory_units');
    }
};
