<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Primero eliminamos la restricción de unicidad existente en el código
        Schema::table('suppliers', function (Blueprint $table) {
            // Eliminar el índice único existente en 'code'
            $table->dropUnique(['code']);
        });

        // Luego agregamos una restricción de unicidad compuesta para code y company_id
        Schema::table('suppliers', function (Blueprint $table) {
            // Agregar un índice único compuesto para code y company_id
            $table->unique(['code', 'company_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Revertir los cambios
        Schema::table('suppliers', function (Blueprint $table) {
            // Eliminar el índice único compuesto
            $table->dropUnique(['code', 'company_id']);

            // Restaurar el índice único original en 'code'
            $table->unique(['code']);
        });
    }
};
