<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('supplier_evaluations')) {
            Schema::create('supplier_evaluations', function (Blueprint $table) {
                $table->id();
                $table->foreignId('company_id')->constrained()->onDelete('cascade');
                $table->foreignId('supplier_id')->constrained()->onDelete('cascade');
                $table->foreignId('created_by')->constrained('users')->onDelete('cascade');
                $table->date('evaluation_date');
                $table->decimal('quality_rating', 3, 1)->default(0); // 0-5 scale
                $table->decimal('delivery_rating', 3, 1)->default(0); // 0-5 scale
                $table->decimal('price_rating', 3, 1)->default(0); // 0-5 scale
                $table->decimal('service_rating', 3, 1)->default(0); // 0-5 scale
                $table->decimal('overall_rating', 3, 1)->default(0); // 0-5 scale
                $table->text('strengths')->nullable();
                $table->text('weaknesses')->nullable();
                $table->text('improvement_areas')->nullable();
                $table->text('notes')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('supplier_evaluations');
    }
};
