<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('inventory_transactions')) {
            Schema::create('inventory_transactions', function (Blueprint $table) {
                $table->id();
                $table->foreignId('company_id')->constrained()->onDelete('cascade');
                $table->enum('transaction_type', [
                    'purchase',
                    'sale',
                    'transfer',
                    'adjustment',
                    'return_to_supplier',
                    'return_from_customer',
                    'maintenance_usage',
                    'write_off'
                ]);
                $table->foreignId('item_id')->constrained('inventory_items')->onDelete('cascade');
                $table->foreignId('warehouse_id')->constrained()->onDelete('cascade');
                $table->foreignId('to_warehouse_id')->nullable()->constrained('warehouses')->onDelete('set null');
                $table->decimal('quantity', 10, 2);
                $table->decimal('unit_price', 10, 2)->nullable();
                $table->string('reference_number')->nullable();
                $table->string('reference_type')->nullable(); // PO, Invoice, Transfer, etc.
                $table->unsignedBigInteger('reference_id')->nullable();
                $table->foreignId('batch_id')->nullable()->constrained('inventory_batches')->onDelete('set null');
                $table->foreignId('serial_id')->nullable()->constrained('inventory_serials')->onDelete('set null');
                $table->foreignId('created_by')->constrained('users')->onDelete('cascade');
                $table->text('notes')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('inventory_transactions');
    }
};
