<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('inventory_items')) {
            Schema::create('inventory_items', function (Blueprint $table) {
                $table->id();
                $table->foreignId('company_id')->constrained()->onDelete('cascade');
                $table->foreignId('category_id')->nullable()->constrained('inventory_categories')->onDelete('set null');
                $table->string('name');
                $table->string('sku')->unique();
                $table->string('barcode')->nullable()->unique();
                $table->text('description')->nullable();
                $table->string('unit')->default('piece'); // piece, kg, meter, etc.
                $table->decimal('purchase_price', 10, 2)->default(0);
                $table->decimal('selling_price', 10, 2)->default(0);
                $table->decimal('min_stock_level', 10, 2)->default(0);
                $table->decimal('max_stock_level', 10, 2)->default(0);
                $table->boolean('track_serial_numbers')->default(false);
                $table->boolean('track_batches')->default(false);
                $table->boolean('is_active')->default(true);
                $table->string('image')->nullable();
                $table->text('technical_specs')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('inventory_items');
    }
};
