<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('tax_settings')) {
            Schema::create('tax_settings', function (Blueprint $table) {
                $table->id();
                $table->foreignId('company_id')->constrained()->onDelete('cascade');
                $table->string('name');
                $table->decimal('rate', 5, 2);
                $table->boolean('is_default')->default(false);
                $table->boolean('is_active')->default(true);
                $table->text('description')->nullable();
                $table->timestamps();
            });

            // إضافة إعدادات الضرائب الافتراضية
            DB::table('tax_settings')->insert([
                [
                    'company_id' => 1,
                    'name' => 'ضريبة القيمة المضافة',
                    'rate' => 15.00,
                    'is_default' => true,
                    'is_active' => true,
                    'description' => 'ضريبة القيمة المضافة بنسبة 15%',
                    'created_at' => now(),
                    'updated_at' => now(),
                ],
                [
                    'company_id' => 1,
                    'name' => 'معفى من الضريبة',
                    'rate' => 0.00,
                    'is_default' => false,
                    'is_active' => true,
                    'description' => 'معفى من الضريبة',
                    'created_at' => now(),
                    'updated_at' => now(),
                ],
            ]);
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tax_settings');
    }
};
