<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('customer_statements')) {
            Schema::create('customer_statements', function (Blueprint $table) {
                $table->id();
                $table->foreignId('company_id')->constrained()->onDelete('cascade');
                $table->foreignId('customer_id')->constrained()->onDelete('cascade');
                $table->foreignId('branch_id')->nullable()->constrained()->onDelete('set null');
                $table->date('transaction_date');
                $table->string('reference_number');
                $table->string('reference_type');
                $table->unsignedBigInteger('reference_id');
                $table->string('description');
                $table->decimal('debit', 10, 2)->default(0);
                $table->decimal('credit', 10, 2)->default(0);
                $table->decimal('balance', 10, 2);
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customer_statements');
    }
};
