<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('branches', function (Blueprint $table) {
            // إضافة حقل notes إذا لم يكن موجودًا
            if (!Schema::hasColumn('branches', 'notes')) {
                $table->text('notes')->nullable()->after('is_active');
            }

            // تغيير اسم is_main إلى is_main_branch إذا كان موجودًا
            if (Schema::hasColumn('branches', 'is_main') && !Schema::hasColumn('branches', 'is_main_branch')) {
                $table->renameColumn('is_main', 'is_main_branch');
            }

            // إضافة حقل is_main_branch إذا لم يكن موجودًا ولم يكن is_main موجودًا
            if (!Schema::hasColumn('branches', 'is_main') && !Schema::hasColumn('branches', 'is_main_branch')) {
                $table->boolean('is_main_branch')->default(false)->after('postal_code');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('branches', function (Blueprint $table) {
            // حذف حقل notes إذا كان موجودًا
            if (Schema::hasColumn('branches', 'notes')) {
                $table->dropColumn('notes');
            }

            // تغيير اسم is_main_branch إلى is_main إذا كان موجودًا
            if (Schema::hasColumn('branches', 'is_main_branch') && !Schema::hasColumn('branches', 'is_main')) {
                $table->renameColumn('is_main_branch', 'is_main');
            }

            // حذف حقل is_main_branch إذا كان موجودًا وتم إضافته في هذه الهجرة
            if (Schema::hasColumn('branches', 'is_main_branch') && !Schema::hasColumn('branches', 'is_main')) {
                $table->dropColumn('is_main_branch');
            }
        });
    }
};
