<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('branches', function (Blueprint $table) {
            // تحقق مما إذا كان عمود is_main موجودًا وعمود is_main_branch غير موجود
            if (Schema::hasColumn('branches', 'is_main') && !Schema::hasColumn('branches', 'is_main_branch')) {
                // تغيير اسم العمود من is_main إلى is_main_branch
                $table->renameColumn('is_main', 'is_main_branch');
            }
            // إذا كان عمود is_main غير موجود وعمود is_main_branch غير موجود أيضًا
            elseif (!Schema::hasColumn('branches', 'is_main') && !Schema::hasColumn('branches', 'is_main_branch')) {
                // إضافة عمود is_main_branch جديد
                $table->boolean('is_main_branch')->default(false)->after('postal_code');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('branches', function (Blueprint $table) {
            // تحقق مما إذا كان عمود is_main_branch موجودًا وعمود is_main غير موجود
            if (Schema::hasColumn('branches', 'is_main_branch') && !Schema::hasColumn('branches', 'is_main')) {
                // تغيير اسم العمود من is_main_branch إلى is_main
                $table->renameColumn('is_main_branch', 'is_main');
            }
            // إذا كان عمود is_main_branch موجودًا وتم إضافته في هذه الهجرة
            elseif (Schema::hasColumn('branches', 'is_main_branch') && !Schema::hasColumn('branches', 'is_main')) {
                // حذف عمود is_main_branch
                $table->dropColumn('is_main_branch');
            }
        });
    }
};
