<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('payments', function (Blueprint $table) {
            // إضافة حقول للدعم المورفولوجي (polymorphic)
            if (!Schema::hasColumn('payments', 'payable_type')) {
                $table->string('payable_type')->nullable()->after('invoice_id');
                $table->unsignedBigInteger('payable_id')->nullable()->after('payable_type');
                $table->index(['payable_type', 'payable_id']);
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('payments', function (Blueprint $table) {
            if (Schema::hasColumn('payments', 'payable_type')) {
                $table->dropIndex(['payable_type', 'payable_id']);
                $table->dropColumn(['payable_type', 'payable_id']);
            }
        });
    }
};
