<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('inventory_alerts', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained()->onDelete('cascade');
            $table->boolean('low_stock_enabled')->default(true);
            $table->decimal('low_stock_threshold', 5, 2)->default(10); // Percentage
            $table->boolean('expiry_enabled')->default(true);
            $table->integer('expiry_threshold_days')->default(30);
            $table->json('notification_emails')->nullable();
            $table->json('notification_users')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('inventory_alerts');
    }
};
