<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateElevatorInventoryRequestItemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('elevator_inventory_request_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('elevator_inventory_request_id')->constrained('elevator_inventory_requests', 'id')->onDelete('cascade')->name('eir_items_request_id_foreign');
            $table->foreignId('inventory_item_id')->constrained('inventory_items');
            $table->foreignId('warehouse_id')->constrained('warehouses');
            $table->decimal('quantity', 10, 2);
            $table->decimal('fulfilled_quantity', 10, 2)->default(0);
            $table->enum('status', ['pending', 'approved', 'rejected', 'fulfilled', 'partially_fulfilled'])->default('pending');
            $table->text('notes')->nullable();
            $table->text('rejection_reason')->nullable();
            $table->enum('priority', ['low', 'medium', 'high', 'urgent'])->default('medium');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('elevator_inventory_request_items');
    }
}
