<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('notifications', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained('companies');
            $table->foreignId('user_id')->nullable()->constrained('users');
            $table->string('type'); // maintenance_due, maintenance_overdue, contract_expiring, etc.
            $table->morphs('notifiable'); // For polymorphic relations (elevator, contract, etc.)
            $table->text('title');
            $table->text('message');
            $table->text('data')->nullable(); // JSON data
            $table->timestamp('read_at')->nullable();
            $table->timestamp('sent_at')->nullable();
            $table->string('status')->default('pending'); // pending, sent, read
            $table->string('priority')->default('normal'); // low, normal, high, urgent
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('notifications');
    }
};
