<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // 1. إضافة عمود الشركة والفرع لجدول المستخدمين إذا لم يكن موجوداً
        if (Schema::hasTable('users') && !Schema::hasColumn('users', 'company_id')) {
            Schema::table('users', function (Blueprint $table) {
                $table->foreignId('company_id')->nullable()->after('id')->constrained()->onDelete('cascade');
                $table->foreignId('branch_id')->nullable()->after('company_id')->constrained()->onDelete('cascade');
            });
        }

        // 2. تحديث جدول الأدوار إذا كان موجوداً
        if (Schema::hasTable('roles') && !Schema::hasColumn('roles', 'company_id')) {
            Schema::table('roles', function (Blueprint $table) {
                $table->foreignId('company_id')->nullable()->after('id')->constrained()->onDelete('cascade');
            });
        }

        // 3. تحديث جدول الصلاحيات إذا كان موجوداً
        if (Schema::hasTable('permissions') && !Schema::hasColumn('permissions', 'resource')) {
            Schema::table('permissions', function (Blueprint $table) {
                if (!Schema::hasColumn('permissions', 'type')) {
                    $table->string('type')->default('feature')->after('description');
                }
                if (!Schema::hasColumn('permissions', 'resource')) {
                    $table->string('resource')->nullable()->after('type');
                }
                if (!Schema::hasColumn('permissions', 'group')) {
                    $table->string('group')->nullable()->after('resource');
                }
            });
        }

        // 4. تحديث جدول علاقة الأدوار والصلاحيات إذا كان موجوداً
        if (Schema::hasTable('permission_role') && !Schema::hasColumn('permission_role', 'created_at')) {
            Schema::table('permission_role', function (Blueprint $table) {
                $table->timestamps();
            });
        }

        // 5. تحديث جدول علاقة المستخدمين والأدوار إذا كان موجوداً
        if (Schema::hasTable('role_user') && !Schema::hasColumn('role_user', 'created_at')) {
            Schema::table('role_user', function (Blueprint $table) {
                $table->timestamps();
            });
        }

        // 6. إنشاء جدول صلاحيات المستخدمين المباشرة إذا لم يكن موجوداً
        if (!Schema::hasTable('user_permission')) {
            Schema::create('user_permission', function (Blueprint $table) {
                $table->id();
                $table->foreignId('user_id')->constrained()->onDelete('cascade');
                $table->foreignId('permission_id')->constrained()->onDelete('cascade');
                $table->boolean('granted')->default(true);
                $table->string('source')->default('direct');
                $table->timestamp('expires_at')->nullable();
                $table->timestamps();
                $table->softDeletes();

                $table->unique(['user_id', 'permission_id']);
            });
        }

        // 7. إنشاء جدول سجل النشاطات إذا لم يكن موجوداً
        if (!Schema::hasTable('activity_logs')) {
            Schema::create('activity_logs', function (Blueprint $table) {
                $table->id();
                $table->foreignId('user_id')->nullable()->constrained()->onDelete('set null');
                $table->foreignId('company_id')->nullable()->constrained()->onDelete('cascade');
                $table->foreignId('branch_id')->nullable()->constrained()->onDelete('cascade');
                $table->string('action');
                $table->string('description');
                $table->morphs('subject');
                $table->json('old_values')->nullable();
                $table->json('new_values')->nullable();
                $table->string('ip_address')->nullable();
                $table->string('user_agent')->nullable();
                $table->timestamps();
            });
        }

        // 8. إنشاء جدول سجل تسجيل الدخول إذا لم يكن موجوداً
        if (!Schema::hasTable('login_history')) {
            Schema::create('login_history', function (Blueprint $table) {
                $table->id();
                $table->foreignId('user_id')->constrained()->onDelete('cascade');
                $table->string('ip_address');
                $table->string('user_agent');
                $table->string('device_type')->nullable();
                $table->string('browser')->nullable();
                $table->string('platform')->nullable();
                $table->string('location')->nullable();
                $table->boolean('success')->default(true);
                $table->string('failure_reason')->nullable();
                $table->timestamps();
            });
        }

        // 9. إنشاء جدول رموز المصادقة الثنائية إذا لم يكن موجوداً
        if (!Schema::hasTable('two_factor_tokens')) {
            Schema::create('two_factor_tokens', function (Blueprint $table) {
                $table->id();
                $table->foreignId('user_id')->constrained()->onDelete('cascade');
                $table->string('token');
                $table->timestamp('expires_at');
                $table->boolean('used')->default(false);
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // لا نقوم بحذف أي جداول أو أعمدة في حالة التراجع
        // لأن هذه الجداول والأعمدة أساسية للنظام
    }
};
