<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('maintenance_contracts')) {
            Schema::create('maintenance_contracts', function (Blueprint $table) {
                $table->id();
                $table->foreignId('company_id')->constrained()->onDelete('cascade');
                $table->foreignId('customer_id')->constrained()->onDelete('cascade');
                $table->foreignId('branch_id')->nullable()->constrained()->onDelete('cascade');
                $table->string('contract_number')->unique();
                $table->string('title');
                $table->date('start_date');
                $table->date('end_date');
                $table->decimal('total_amount', 10, 2);
                $table->enum('billing_cycle', ['monthly', 'quarterly', 'semi_annually', 'annually'])->default('monthly');
                $table->enum('status', ['draft', 'active', 'expired', 'cancelled'])->default('draft');
                $table->integer('visits_per_year');
                $table->text('terms_conditions')->nullable();
                $table->text('notes')->nullable();
                $table->timestamps();
                $table->softDeletes();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('maintenance_contracts');
    }
};
