<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('elevators')) {
            Schema::create('elevators', function (Blueprint $table) {
                $table->id();
                $table->foreignId('company_id')->constrained()->onDelete('cascade');
                $table->foreignId('customer_id')->constrained()->onDelete('cascade');
                $table->foreignId('location_id')->constrained()->onDelete('cascade');
                $table->foreignId('branch_id')->nullable()->constrained()->onDelete('cascade');
                $table->string('serial_number')->unique();
                $table->string('model');
                $table->string('manufacturer');
                $table->date('installation_date');
                $table->date('warranty_end_date')->nullable();
                $table->integer('capacity')->comment('in kg');
                $table->integer('floors_count');
                $table->decimal('speed', 5, 2)->comment('in m/s');
                $table->enum('type', ['passenger', 'freight', 'hospital', 'panoramic', 'other'])->default('passenger');
                $table->enum('status', ['operational', 'under_maintenance', 'out_of_service', 'installation'])->default('operational');
                $table->string('qr_code')->nullable();
                $table->text('specifications')->nullable();
                $table->text('notes')->nullable();
                $table->timestamps();
                $table->softDeletes();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('elevators');
    }
};
