<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('activity_logs', function (Blueprint $table) {
            // إضافة الأعمدة المفقودة إذا لم تكن موجودة
            if (!Schema::hasColumn('activity_logs', 'old_values')) {
                $table->json('old_values')->nullable();
            }

            if (!Schema::hasColumn('activity_logs', 'new_values')) {
                $table->json('new_values')->nullable();
            }

            if (!Schema::hasColumn('activity_logs', 'url')) {
                $table->string('url')->nullable();
            }

            if (!Schema::hasColumn('activity_logs', 'method')) {
                $table->string('method')->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('activity_logs', function (Blueprint $table) {
            // حذف الأعمدة إذا كانت موجودة
            $columns = [
                'old_values',
                'new_values',
                'url',
                'method'
            ];

            // حذف الأعمدة الموجودة فقط
            $existingColumns = [];
            foreach ($columns as $column) {
                if (Schema::hasColumn('activity_logs', $column)) {
                    $existingColumns[] = $column;
                }
            }

            if (!empty($existingColumns)) {
                $table->dropColumn($existingColumns);
            }
        });
    }
};
